/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTexture$Type;
import com.mojang.authlib.minecraft.SashokProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.InetAddress;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import launcher.JILLjIiILlLLIijIiiJiIlJIJLLjiIJl;
import launcher.JiIIJljllilLlLLljliLJjiiiJLjjJlj;
import launcher.iJlllJjLIljjjiILLLLiJlLLiIJljllJ;
import launcher.iLjIjjLjIlILjliIjiIlJlIJllLILiij;
import launcher.iLlJjiJjLJilIjIjiLlljLLiillJJiJI;
import launcher.lJIilIlIljLjJljJJIJjLLJIlJjlIJjj;
import launcher.lilLJIjiLlJiiLiJJIlIIjliIILjjiil;
import launcher.lililJlLlilILlilLIJJlLlijLJiJJjj;

public class SashokMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final boolean NO_TEXTURES = Boolean.parseBoolean("launcher.authlib.noTextures");

    public SashokMinecraftSessionService(AuthenticationService authenticationService) {
        super(authenticationService);
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Patched MinecraftSessionService created");
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj;
        UUID uUID = gameProfile.getId();
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillProfileProperties, UUID: %s", uUID);
        if (uUID == null) {
            return gameProfile;
        }
        try {
            jiIIJljllilLlLLljliLJjiiiJLjjJlj = (JiIIJljllilLlLLljliLJjiiiJLjjJlj)new lililJlLlilILlilLIJJlLlijLJiJJjj(uUID).request();
        }
        catch (Throwable throwable) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Couldn't fetch profile properties for '%s': %s", gameProfile, throwable);
            return gameProfile;
        }
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj == null) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Couldn't fetch profile properties for '%s' as the profile does not exist", gameProfile);
            return gameProfile;
        }
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Successfully fetched profile properties for '%s'", gameProfile);
        SashokMinecraftSessionService.fillTextureProperties(gameProfile, jiIIJljllilLlLLljliLJjiiiJLjjJlj);
        return SashokMinecraftSessionService.toGameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj);
    }

    @Override
    public Map getTextures(GameProfile gameProfile, boolean bl) {
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("getTextures, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getId());
        EnumMap<MinecraftProfileTexture$Type, SashokProfileTexture> enumMap = new EnumMap<MinecraftProfileTexture$Type, SashokProfileTexture>(MinecraftProfileTexture$Type.class);
        if (!NO_TEXTURES) {
            Property property;
            Property property2 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinURL"), null);
            Property property3 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinDigest"), null);
            if (property2 != null && property3 != null) {
                enumMap.put(MinecraftProfileTexture$Type.SKIN, new SashokProfileTexture(property2.getValue(), property3.getValue()));
            }
            Property property4 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakURL"), null);
            Property property5 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakDigest"), null);
            if (property4 != null && property5 != null) {
                enumMap.put(MinecraftProfileTexture$Type.CAPE, new SashokProfileTexture(property4.getValue(), property5.getValue()));
            }
            if (enumMap.size() != MinecraftProfileTexture.PROFILE_TEXTURE_COUNT && (property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("textures"), null)) != null) {
                SashokMinecraftSessionService.getTexturesMojang(enumMap, property.getValue(), gameProfile);
            }
        }
        return enumMap;
    }

    public GameProfile hasJoinedServer(GameProfile gameProfile, String string) {
        JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj;
        String string2 = gameProfile.getName();
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("checkServer, Username: '%s', Server ID: %s", string2, string);
        try {
            jiIIJljllilLlLLljliLJjiiiJLjjJlj = (JiIIJljllilLlLLljliLJjiiiJLjjJlj)new iLlJjiJjLJilIjIjiLlljLLiillJJiJI(string2, string).request();
        }
        catch (Throwable throwable) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.error(throwable);
            throw new AuthenticationUnavailableException(throwable);
        }
        return jiIIJljllilLlLLljliLJjiiiJLjjJlj == null ? null : SashokMinecraftSessionService.toGameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String string, InetAddress inetAddress) {
        return this.hasJoinedServer(gameProfile, string);
    }

    @Override
    public void joinServer(GameProfile gameProfile, String string, String string2) {
        boolean bl;
        if (!iLjIjjLjIlILjliIjiIlJlIJllLILiij.isLaunched()) {
            throw new AuthenticationException("Bad Login (Cheater)");
        }
        String string3 = gameProfile.getName();
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("joinServer, Username: '%s', Access token: %s, Server ID: %s", string3, string, string2);
        try {
            bl = (Boolean)new JILLjIiILlLLIijIiiJiIlJIJLLjiIJl(string3, string, string2).request();
        }
        catch (Throwable throwable) {
            throw new AuthenticationUnavailableException(throwable);
        }
        if (!bl) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }

    public static void fillTextureProperties(GameProfile gameProfile, JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj) {
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Username: '%s'", gameProfile.getName());
        if (NO_TEXTURES) {
            return;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin != null) {
            propertyMap.put("skinURL", new Property("skinURL", jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin.url, ""));
            propertyMap.put("skinDigest", new Property("skinDigest", lJIilIlIljLjJljJJIJjLLJIlJjlIJjj.toHex(jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin.digest), ""));
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Has skin texture for username '%s'", gameProfile.getName());
        }
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak != null) {
            propertyMap.put("cloakURL", new Property("cloakURL", jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak.url, ""));
            propertyMap.put("cloakDigest", new Property("cloakDigest", lJIilIlIljLjJljJJIJjLLJIlJjlIJjj.toHex(jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak.digest), ""));
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Has cloak texture for username '%s'", gameProfile.getName());
        }
    }

    public static GameProfile toGameProfile(JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj) {
        GameProfile gameProfile = new GameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj.uuid, jiIIJljllilLlLLljliLJjiiiJLjjJlj.username);
        SashokMinecraftSessionService.fillTextureProperties(gameProfile, jiIIJljllilLlLLljliLJjiiiJLjjJlj);
        return gameProfile;
    }

    private static void getTexturesMojang(Map map, String string, GameProfile gameProfile) {
        JsonObject jsonObject;
        Object object;
        Object object2;
        try {
            object2 = Base64.getDecoder().decode(string);
            object = new String((byte[])object2, iJlllJjLIljjjiILLLLiJlLLiIJljllJ.UNICODE_CHARSET);
            jsonObject = JSON_PARSER.parse(object).getAsJsonObject().getAsJsonObject("textures");
        }
        catch (Throwable throwable) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.error("Could not decode textures payload, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getId());
            return;
        }
        object2 = SashokProfileTexture.PROFILE_TEXTURE_TYPES.iterator();
        while (object2.hasNext()) {
            JsonElement jsonElement;
            JsonElement jsonElement2;
            object = (MinecraftProfileTexture$Type)((Object)object2.next());
            if (map.containsKey(object) || (jsonElement2 = jsonObject.get(((Enum)object).name())) == null || !jsonElement2.isJsonObject() || !(jsonElement = jsonElement2.getAsJsonObject().get("url")).isJsonPrimitive()) continue;
            map.put(object, new SashokProfileTexture(jsonElement.getAsString()));
        }
    }
}

