/*
 * Decompiled with CFR 0.152.
 */
package ru.bestfoxy.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture$Type;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import launcher.JILLjIiILlLLIijIiiJiIlJIJLLjiIJl;
import launcher.JiIIJljllilLlLLljliLJjiiiJLjjJlj;
import launcher.iLlJjiJjLJilIjIjiLlljLLiillJJiJI;
import launcher.lJIilIlIljLjJljJJIJjLLJIlJjlIJjj;
import launcher.lilLJIjiLlJiiLiJJIlIIjliIILjjiil;
import launcher.lililJlLlilILlilLIJJlLlijLJiJJjj;

public class BFMinecraftSessionService {
    public static final boolean NO_TEXTURES = Boolean.parseBoolean("launcher.authlib.noTextures");

    private BFMinecraftSessionService() {
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Patched BFMinecraftSessionService created");
    }

    public static BFMinecraftSessionService create() {
        return new BFMinecraftSessionService();
    }

    public void joinServer(UUID uUID, String string, String string2) {
        boolean bl;
        JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj;
        try {
            jiIIJljllilLlLLljliLJjiiiJLjjJlj = (JiIIJljllilLlLLljliLJjiiiJLjjJlj)new lililJlLlilILlilLIJJlLlijLJiJJjj(uUID).request();
        }
        catch (Throwable throwable) {
            throw new AuthenticationException("Error when get PlayerProfile by UUID", throwable);
        }
        String string3 = jiIIJljllilLlLLljliLJjiiiJLjjJlj.username;
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("joinServer, Username: '%s', Access token: %s, Server ID: %s", string3, string, string2);
        try {
            bl = (Boolean)new JILLjIiILlLLIijIiiJiIlJIJLLjiIJl(string3, string, string2).request();
        }
        catch (Throwable throwable) {
            throw new AuthenticationUnavailableException(throwable);
        }
        if (!bl) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }

    public GameProfile hasJoinedServer(String string, String string2, InetAddress inetAddress) {
        JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj;
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("checkServer, Username: '%s', Server ID: %s", string, string2);
        try {
            jiIIJljllilLlLLljliLJjiiiJLjjJlj = (JiIIJljllilLlLLljliLJjiiiJLjjJlj)new iLlJjiJjLJilIjIjiLlljLLiillJJiJI(string, string2).request();
        }
        catch (Throwable throwable) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.error(throwable);
            throw new AuthenticationUnavailableException(throwable);
        }
        return jiIIJljllilLlLLljliLJjiiiJLjjJlj == null ? null : BFMinecraftSessionService.toGameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj);
    }

    public GameProfile fetchProfile(UUID uUID, boolean bl) {
        JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj;
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fetchProfile, UUID: %s", uUID);
        try {
            jiIIJljllilLlLLljliLJjiiiJLjjJlj = (JiIIJljllilLlLLljliLJjiiiJLjjJlj)new lililJlLlilILlilLIJJlLlijLJiJJjj(uUID).request();
        }
        catch (Throwable throwable) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Couldn't fetch profile properties for '%s': %s", uUID.toString(), throwable);
            return null;
        }
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj == null) {
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Couldn't fetch profile properties for '%s' as the profile does not exist", uUID.toString());
            return null;
        }
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("Successfully fetched profile properties for '%s'", jiIIJljllilLlLLljliLJjiiiJLjjJlj.username);
        return BFMinecraftSessionService.toGameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj);
    }

    public String getEncodedPacketTextures(GameProfile gameProfile) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        JsonObject jsonObject3 = new JsonObject();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinURL"), null);
        Property property2 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinDigest"), null);
        if (property != null && property2 != null) {
            jsonObject = new JsonObject();
            jsonObject.add("url", (JsonElement)new JsonPrimitive(property.getValue()));
            jsonObject.add("digest", (JsonElement)new JsonPrimitive(property2.getValue()));
            jsonObject3.add(MinecraftProfileTexture$Type.SKIN.name(), (JsonElement)jsonObject);
        }
        Property property3 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakURL"), null);
        Property property4 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakDigest"), null);
        if (property3 != null && property4 != null) {
            jsonObject = new JsonObject();
            jsonObject.add("url", (JsonElement)new JsonPrimitive(property3.getValue()));
            jsonObject.add("digest", (JsonElement)new JsonPrimitive(property4.getValue()));
            jsonObject3.add(MinecraftProfileTexture$Type.CAPE.name(), (JsonElement)jsonObject);
        }
        jsonObject2.add("textures", (JsonElement)jsonObject3);
        return !jsonObject2.entrySet().isEmpty() ? Base64.getEncoder().encodeToString(jsonObject2.toString().getBytes(StandardCharsets.UTF_8)) : null;
    }

    public static GameProfile toGameProfile(JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj) {
        GameProfile gameProfile = new GameProfile(jiIIJljllilLlLLljliLJjiiiJLjjJlj.uuid, jiIIJljllilLlLLljliLJjiiiJLjjJlj.username);
        BFMinecraftSessionService.fillTextureProperties(gameProfile, jiIIJljllilLlLLljliLJjiiiJLjjJlj);
        return gameProfile;
    }

    private static void fillTextureProperties(GameProfile gameProfile, JiIIJljllilLlLLljliLJjiiiJLjjJlj jiIIJljllilLlLLljliLJjiiiJLjjJlj) {
        lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Username: '%s'", gameProfile.getName());
        if (NO_TEXTURES) {
            return;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin != null) {
            propertyMap.put("skinURL", new Property("skinURL", jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin.url, ""));
            propertyMap.put("skinDigest", new Property("skinDigest", lJIilIlIljLjJljJJIJjLLJIlJjlIJjj.toHex(jiIIJljllilLlLLljliLJjiiiJLjjJlj.skin.digest), ""));
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Has skin texture for username '%s'", gameProfile.getName());
        }
        if (jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak != null) {
            propertyMap.put("cloakURL", new Property("cloakURL", jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak.url, ""));
            propertyMap.put("cloakDigest", new Property("cloakDigest", lJIilIlIljLjJljJJIJjLLJIlJjlIJjj.toHex(jiIIJljllilLlLLljliLJjiiiJLjjJlj.cloak.digest), ""));
            lilLJIjiLlJiiLiJJIlIIjliIILjjiil.debug("fillTextureProperties, Has cloak texture for username '%s'", gameProfile.getName());
        }
    }
}

