var app, stage, scene, loginScene,registerScene, menuScene, jvmDirName,startScene;

var rootPane, loginPane,registerPane, authPane, menuPane,startPane;

// Engine scripts (API should be imported through static link)
launcher.loadScript(LauncherClass.static.getResourceURL("engine/api.js"));
launcher.loadScript(Launcher.getResourceURL("config.js"));

// launcher scripts
launcher.loadScript(Launcher.getResourceURL("launcher/controller.js"));

// Override application class
var LauncherApp = Java.extend(JSApplication, {
    init: function() {
        app = JSApplication.getInstance();
        cliParams.init(app.getParameters());
        settings.load();
    }, start: function(primaryStage) {
        stage = primaryStage;
		stage.initStyle(javafx.stage.StageStyle.TRANSPARENT);
        stage.setResizable(false);
        stage.setTitle(config.title);

        // Set icons
        config.icons.forEach(function(icon) {
            var iconURL = Launcher.getResourceURL(icon).toString();
            stage.getIcons().add(new javafx.scene.image.Image(iconURL));
        });

        // Load launcher FXML
        startPane = loadFXML("launcher/start.fxml");
        loginPane = loadFXML("launcher/login.fxml");
        registerPane = loadFXML("launcher/register.fxml");
        menuPane = loadFXML("launcher/mainmenu.fxml");

        startScene = new javafx.scene.Scene(startPane);
        startScene.setFill(javafx.scene.paint.Color.TRANSPARENT);


        registerScene = new javafx.scene.Scene(registerPane);
        registerScene.setFill(javafx.scene.paint.Color.TRANSPARENT);

        loginScene = new javafx.scene.Scene(loginPane);
        loginScene.setFill(javafx.scene.paint.Color.TRANSPARENT);

        menuScene = new javafx.scene.Scene(menuPane);
        menuScene.setFill(javafx.scene.paint.Color.TRANSPARENT);

        setCurrentScene(startScene);

        initLauncher();

    }, stop: function() {
        settings.save();
    }
});

// Helper functions
// Helper functions
function loadFXML(name) {
    java.lang.System.setProperty("file.encoding", "UTF-8");

    var loader = new javafx.fxml.FXMLLoader(Launcher.getResourceURL(name));
    loader.setCharset(java.nio.charset.StandardCharsets.UTF_8);
    return loader.load();
    
}

function setCurrentScene(scene) {
    stage.setScene(scene);
    rootPane = scene.getRoot();
    dimPane = rootPane.lookup("#mask");
    // Show new stage
    stage.sizeToScene();
    stage.show();
}

// Start function - there all begins
function start(args) {
    // Set JVM dir name
    LogHelper.debug("Setting JVM dir name");
    switch (JVMHelper.OS_TYPE) {
        case JVMHelperOS.MUSTDIE:
                if(JVMHelper.SUPPORTING_GRAPHICS) {
                    jvmDirName = JVMHelper.OS_BITS === 32 ? config.jvmMustdie32Dir :
                                 JVMHelper.OS_BITS === 64 ? config.jvmMustdie64Dir : config.jvmUnknownDir;
                } else {
                    jvmDirName = JVMHelper.OS_BITS === 32 ? config.jvmMustdie32NotSupportingGraphicDir :
                                 JVMHelper.OS_BITS === 64 ? config.jvmMustdie64NotSupportingGraphicDir : config.jvmUnknownDir;
                }
                break;
        case JVMHelperOS.LINUX: jvmDirName = JVMHelper.OS_BITS === 32 ? config.jvmLinux32Dir : jvmDirName = JVMHelper.OS_BITS === 64 ? config.jvmLinux64Dir : config.jvmUnknownDir; break;
        case JVMHelperOS.MACOSX: jvmDirName = JVMHelper.OS_BITS === 64 ? config.jvmMacOSXDir : config.jvmUnknownDir; break;
        default: jvmDirName = config.jvmUnknownDir; LogHelper.warning("Unknown OS: '%s'", JVMHelper.OS_TYPE.name); break;
    }

    // Set font rendering properties
    LogHelper.debug("Setting FX properties");
    java.lang.System.setProperty("prism.lcdtext", "false");

    // Start laucher JavaFX stage
    LogHelper.debug("Launching JavaFX application");
    javafx.application.Application.launch(LauncherApp.class, args);
}