// Ининциализируем кучу всяких переменных
var authPane,registrationPane,PrePane, dimPane, serverPane,startPane;

// Переменные от окна входа
var shadow,langData, loginField,emailField, passwordField, savePasswordBox, forgotButton, homeButton, registerButton, vkButton, dButton, telegramButton, youtubeButton,login,password;
// Переменные от основной менюшки
var serverList, serverInfo, serverYT, serverVideo, serverMods, serverDescription, serverEntrance, serverLabel, serverMotto, serverStatus,captchaPane,webView;

// Прочие вспомогалки
var profilesList = []; // Ассоциативный массив: "кнопка сервера" => "профиль сервера"
var movePoint = null; // Координата, хранящая опроную точку при Drag'е
var pingers = {}; // ддосеры серверов
var loginData; // Буфер для данных авторизации

function initLauncher() {
    // Инициализируем основы\
    initStartScene();
    initLoginScene();
    initMenuScene();
    initRegistrationScene();
    // Инициализируем доп. менюшки
    processing.initOverlay();
    settings.initOverlay();
    update.initOverlay();
	
    // Делаем запрос на проверку свежести лаунчера, ну и сервера заодно обновляем
    verifyLauncher();
}
function loadLocalizedStrings() {
    var lang = java.lang.System.getProperty("user.language");
    print("System Language: " + lang); // Выводим язык системы для отладки

    // Определяем путь к файлу свойств в зависимости от языка
    var resourcePath = "/runtime/runtime_" + lang + ".properties";

    // Проверяем, существует ли файл для выбранного языка
    var inputStream = Launcher.class.getResourceAsStream(resourcePath);
    if (inputStream == null) {
        print("Language file not found for: " + lang + ". Falling back to default (en).");
        // Если файл не найден, устанавливаем язык по умолчанию
        lang = "en";
        resourcePath = "/runtime/runtime_" + lang + ".properties";
        inputStream = Launcher.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new java.io.FileNotFoundException("Default language file not found: " + resourcePath);
        }
    }

    // Загружаем языковые данные с учетом UTF-8 кодировки
    langData = loadLanguageResourceFile(inputStream);
}

function loadLanguageResourceFile(inputStream) {
    var properties = new java.util.Properties();
    properties.load(new java.io.InputStreamReader(inputStream, java.nio.charset.StandardCharsets.UTF_8));
    inputStream.close();
    return properties;
}

function setInverseClip(node, clip) {
	var inverse = new (Java.type("javafx.scene.shape.Rectangle"))();
	/*
	clip.setX(0);
	clip.setY(244);
	inverse.setWidth( node.getLayoutBounds().getWidth() );
	inverse.setHeight( node.getLayoutBounds().getHeight() );*/
	Java.type("java.lang.System").out.println(node);
	Java.type("java.lang.System").out.println(clip);
	var pattern = new (Java.type("javafx.scene.paint.ImagePattern"))(clip.getImage());
	Java.type("java.lang.System").out.println(pattern);
	inverse.fill(pattern);
	Java.type("java.lang.System").out.println();
	node.setClip(clip);
	
}

function initStartScene() {
    loadLocalizedStrings();

    startPane.setOnMousePressed(function(event) {
        movePoint = new javafx.geometry.Point2D(event.getSceneX(), event.getSceneY());
    });
    startPane.setOnMouseDragged(function(event) {
        if (movePoint === null) {
            return;
        }
        // Обновляем позицию панели
        stage.setX(event.getScreenX() - movePoint.getX());
        stage.setY(event.getScreenY() - movePoint.getY());
    });

    var pane = startPane.lookup("#layout");


    telegramButton = pane.lookup("#telegrambtn");
    telegramButton.setOnMouseMoved(function(event) { rootPane.fireEvent(event) });
    telegramButton.setOnAction(function(event) {
        openURL(config.telegramURL);
    });

    youtubeButton = pane.lookup("#youtubebtn");
    youtubeButton.setOnMouseMoved(function(event) { rootPane.fireEvent(event) });
    youtubeButton.setOnAction(function(event) {
        openURL(config.youtubeURL);
    });

    pane.lookup("#discordbtn").setOnAction(function(event) {
        openURL(config.discordURL);
    });

    pane.lookup("#vkbtn").setOnAction(function(event) {
        openURL(config.vkURL);
    });

    pane.lookup("#exitbtn").setOnAction(function(event) {
        javafx.application.Platform.exit();
    });

  


    pane.lookup("#register").setOnAction((function (event) {
        setCurrentScene(registerScene);
     }));
     pane.lookup("#login").setOnAction((function (event) {
        setCurrentScene(loginScene);
     }));

     pane.lookup("#tittle").setText(langData.getProperty("runtime.scenes.start.tittle"));
     pane.lookup("#tittle_under").setText(langData.getProperty("runtime.scenes.start.tittle_under"));

     pane.lookup("#first_go").setText(langData.getProperty("runtime.scenes.start.first_go"));
     pane.lookup("#twirth_go").setText(langData.getProperty("runtime.scenes.start.twirth_go"));

     pane.lookup("#register").setText(langData.getProperty("runtime.scenes.start.register_button"));
     pane.lookup("#login").setText(langData.getProperty("runtime.scenes.start.login_button"));

}
var CookieManager = Java.type("java.net.CookieManager");
var CookieHandler = Java.type("java.net.CookieHandler");

var cookieManager = new CookieManager();
CookieHandler.setDefault(cookieManager);
function performAuth(login, password) {
    if (!login || !password) {
        print("Login or password is missing!");
        return;
    }
    
    // Декодируем пароль из Base64 и выполняем авторизацию
    var rsaPassword = settings.setPassword(password);
    settings.login = login;
    settings.rsaPassword = rsaPassword;
    doAuth(login, rsaPassword);
}

function initRegistrationScene() {
    registerPane.setOnMousePressed(function(event) {
        movePoint = new javafx.geometry.Point2D(event.getSceneX(), event.getSceneY());
    });
    registerPane.setOnMouseDragged(function(event) {
        if (movePoint === null) {
            return;
        }
        // Обновляем позицию панели
        stage.setX(event.getScreenX() - movePoint.getX());
        stage.setY(event.getScreenY() - movePoint.getY());
    });

    var pane = registerPane.lookup("#layout");
    var backgroundPane = registerPane.lookup("#background");

    captchaPane = pane.lookup("#captchaPane");

    telegramButton = pane.lookup("#telegrambtn");
    telegramButton.setOnMouseMoved(function(event) { rootPane.fireEvent(event) });
    telegramButton.setOnAction(function(event) {
        openURL(config.telegramURL);
    });

    youtubeButton = pane.lookup("#youtubebtn");
    youtubeButton.setOnMouseMoved(function(event) { rootPane.fireEvent(event) });
    youtubeButton.setOnAction(function(event) {
        openURL(config.youtubeURL);
    });

    pane.lookup("#discordbtn").setOnAction(function(event) {
        openURL(config.discordURL);
    });

    pane.lookup("#vkbtn").setOnAction(function(event) {
        openURL(config.vkURL);
    });

    registerPane.lookup("#exitbtn").setOnAction(function(event) {
        javafx.application.Platform.exit();
    });
    backgroundPane.lookup("#tittle").setText(langData.getProperty("runtime.scenes.start.tittle"));
    backgroundPane.lookup("#tittle_under").setText(langData.getProperty("runtime.scenes.login.tittle_under"));
    backgroundPane.lookup("#label-login").setText(langData.getProperty("runtime.scenes.register.label-login"));


    // Получаем WebView и его движок
    var webView = captchaPane.lookup("#webView");
    var webEngine = webView.getEngine();
    webEngine.setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36; lang=ua");
    webEngine.setJavaScriptEnabled(true);
    var ChangeListener = Java.type("javafx.beans.value.ChangeListener");
    var URLDecoder = Java.type("java.net.URLDecoder");

        var listener = Java.extend(ChangeListener, {
            changed: function(obs, oldLocation, newLocation) {
                try {
                    var url = new java.net.URL(newLocation);
                    var queryParams = url.getQuery(); // Получаем строку параметров
    
                    if (queryParams) {
                        var params = queryParams.split("&");
                        var login;
                        var encodedPassword;
    
                        params.forEach(function(param) {
                            var keyValue = param.split("=");
                            if (keyValue[0] === "login") {
                                login = keyValue[1];
                            }
                            if (keyValue[0] === "password") {
                                encodedPassword = keyValue[1];
                            }
                        });
    
                        if (login && encodedPassword) {
                            var decodedPassword = URLDecoder.decode(encodedPassword, "UTF-8");
                            var password = new java.lang.String(java.util.Base64.getDecoder().decode(decodedPassword));
                            

                            performAuth(login, password);
                        }
                    }
                } catch (e) {
                    print("Error: " + e);
                }
            }
        });


    webEngine.locationProperty().addListener(new listener());


    var ChangeListener = Java.type('javafx.beans.value.ChangeListener');


    backgroundPane.lookup("#back").setOnAction((function (event) {
        setCurrentScene(startScene);
     }));

    webEngine.load("https://cubixworld.net/register_in_app_pc");
}





function initLoginScene() {
    loginPane.setOnMousePressed(function(event){ movePoint = new javafx.geometry.Point2D(event.getSceneX(), event.getSceneY())});
    loginPane.setOnMouseDragged(function(event) {
        if(movePoint === null) {
            return;
        }

        // Обновляем позицию панели
        stage.setX(event.getScreenX() - movePoint.getX());
        stage.setY(event.getScreenY() - movePoint.getY());
    });
	

	loginPane.lookup("#mask");


    loginPane.lookup("#exitbtn").setOnAction(function(event){ javafx.application.Platform.exit()});


     var pane = loginPane.lookup("#layout");
    authPane = pane;

    

    // Lookup login field
    loginField = pane.lookup("#login");
	loginField.setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 

    loginField.setOnAction(goAuth);
    if (settings.login !== null) {
        loginField.setText(settings.login);
    }



    // Lookup password field
    passwordField = pane.lookup("#password");
	passwordField.setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 
    passwordField.setOnAction(goAuth);
    if (settings.rsaPassword !== null) {
        passwordField.getStyleClass().add("hasSaved");
        passwordField.setPromptText("*** Сохранённый ***");
    }

    // Lookup password saving checkbox
    savePasswordBox = true


    forgotButton = pane.lookup("#forgotbtn");
    forgotButton.setOnAction(function(event){
        openURL(config.forgotURL);
    });

	
    pane.lookup("#registerbtn").setOnAction((function (event) {
        setCurrentScene(registerScene);
    }));


    telegramButton = pane.lookup("#homebtn");
    telegramButton.setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 
    telegramButton.setOnAction(function(event){
        openURL(config.homeURL);
    });

    telegramButton = pane.lookup("#telegrambtn");
    telegramButton.setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 
    telegramButton.setOnAction(function(event){
        openURL(config.telegramURL);
    });


    youtubeButton = pane.lookup("#youtubebtn");
    youtubeButton.setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 
    youtubeButton.setOnAction(function(event){
        openURL(config.youtubeURL);
    });
    

    pane.lookup("#discordbtn").setOnAction((function (event) {
        openURL(config.discordURL);
    }));


    pane.lookup("#vkbtn").setOnAction((function (event) {
        openURL(config.vkURL);
    }));
    pane.lookup("#registerbtn").setOnAction((function (event) {
       setCurrentScene(registerScene);
    }));

    // Lookup action buttons
    pane.lookup("#goAuth").setOnAction(goAuth);
	pane.lookup("#goAuth").setOnMouseMoved(function(event){rootPane.fireEvent(event)}); 



    pane.lookup("#back").setOnAction((function (event) {
        setCurrentScene(startScene);
     }));


    pane.lookup("#tittle").setText(langData.getProperty("runtime.scenes.start.tittle"));
    pane.lookup("#tittle_under").setText(langData.getProperty("runtime.scenes.login.tittle_under"));
    pane.lookup("#label-login").setText(langData.getProperty("runtime.scenes.login.label-login"));
    
    pane.lookup("#goAuth").setText(langData.getProperty("runtime.scenes.login.goAuth"));
    pane.lookup("#forgotbtn").setText(langData.getProperty("runtime.scenes.login.forgotbtn"));
    pane.lookup("#registerbtn").setText(langData.getProperty("runtime.scenes.login.register_button"));
    
    pane.lookup("#login").setPromptText(langData.getProperty("runtime.scenes.login.login"));
    pane.lookup("#password").setPromptText(langData.getProperty("runtime.scenes.login.password"));


}

function initMenuScene() {
    menuPane.setOnMousePressed(function(event){ movePoint = new javafx.geometry.Point2D(event.getSceneX(), event.getSceneY())});
    menuPane.setOnMouseDragged(function(event) {
        if(movePoint === null) {
            return;
        }

        // Обновляем позицию панели
        stage.setX(event.getScreenX() - movePoint.getX());
        stage.setY(event.getScreenY() - movePoint.getY());
    });
    menuPane.lookup("#exitbtn").setOnAction(function(event){ javafx.application.Platform.exit()});


	var img = new javafx.scene.image.ImageView(menuPane.lookup("#background").getImage());
	menuPane.lookup("#mask").setClip(img);
	
    var pane = menuPane.lookup("#serverPane");
    serverPane = pane;

    menuPane.lookup("#settingsbtn").setOnAction(goSettings);

    serverList = pane.lookup("#serverlist").getContent();


	
    pane.lookup("#logoutbtn").setOnAction(function(){
        setCurrentScene(loginScene);
    });
    // Lookup login field

    pane.lookup("#label-text-about").setText(langData.getProperty("runtime.scenes.servermenu.tittle"));

}

function initOffline() {
    // Меняем заголовок(Хер его знает зачем, его всё равно нигде не видно...
    stage.setTitle(config.title + " [Offline]");

    // Set login field as username field

    if (!VerifyHelper.isValidUsername(settings.login)) {
        loginField.setText(""); // Reset if not valid
    }

    // Disable password field
    passwordField.setDisable(true);

    passwordField.setText("");
}

/* ======== Handler functions ======== */
function goAuth(event) {
    // Verify there's no other overlays
    if (overlay.current !== null) {
        return;
    }

    // Get login
    var login = loginField.getText();
    if (login.isEmpty()) {
        return; // Maybe throw exception?)
    }

    // Get password if online-mode
    var rsaPassword = null;
    if (!passwordField.isDisable()) {
        var password = passwordField.getText();
        if (!password.isEmpty()) {
            rsaPassword = settings.setPassword(password);
        } else if (settings.rsaPassword !== null) {
            rsaPassword = settings.rsaPassword;
        } else {
            return;
        }

        settings.rsaPassword = true ? rsaPassword : null;
    }

    // Show auth overlay
    settings.login = login;
    doAuth(login, rsaPassword);
}

function goSettings(event) {
    // Verify there's no other overlays
    if (overlay.current !== null) {
        return;
    }

    // Show settings overlay
    overlay.show(settings.overlay, null);
}

/* ======== Processing functions ======== */
function verifyLauncher() {
    processing.resetOverlay();
    overlay.show(processing.overlay, function(event) makeLauncherRequest(function(result) {
			settings.lastSign = result.sign;
            settings.lastProfiles = result.profiles;
		if (result.binary !== null) {
            LauncherRequest.update(Launcher.getConfig(), result);
            return;
        }

        // Init offline if set
        if (settings.offline) {
            initOffline();
        }

        // Update profiles list and hide overlay
        updateProfilesList(result.profiles);
        overlay.hide(0, function() {
            if (settings.rsaPassword !== null) {
                goAuth(null);
            }
        });
    }));
}
function doAuth(login, rsaPassword) {
    processing.resetOverlay();
    overlay.show(processing.overlay, function (event) {
        makeAuthRequest(login, rsaPassword, function (result) {
            loginData = { pp: result.pp , accessToken: result.accessToken};
            overlay.hide(0, function () {
				// try{
				// 	var url = new java.net.URL(config.balanceAPI+settings.login);
				// 	var con = url.openConnection();
				// 	con.setRequestMethod("GET");
				// 	con.setRequestProperty("User-Agent", "Mozilla/5.0");
				// 	var sc = new java.util.Scanner(con.getInputStream());
				// 	menuPane.lookup("#money").setText(sc.nextLine());
				// 	sc.close();
				// }catch(e){
				// 	menuPane.lookup("#money").setText("Ошибка");
				// }
                menuPane.lookup("#money").setText("");
				
				menuPane.lookup("#playername").setText(settings.login);
                setCurrentScene(menuScene);
            });
            return result;
        })
    });
}

function doUpdate(profile, pp, accessToken) {
    var digest = profile.object.isUpdateFastCheck();
    // Update JVM dir
    update.resetOverlay("Обновление файлов JVM");
  var jvmCustomDir = profile.object.getJvmVersion();
    overlay.swap(0, update.overlay, function(event) {
        var jvmDir = settings.updatesDir.resolve(jvmCustomDir);
        makeUpdateRequest(jvmCustomDir, jvmDir, null, digest, function(jvmHDir) {
            settings.lastHDirs.put(jvmDirName, jvmHDir);

            // Update asset dir
            update.resetOverlay("Обновление файлов ресурсов");
            var assetDirName = profile.object.block.getEntryValue("assetDir", StringConfigEntryClass);
            var assetDir = settings.updatesDir.resolve(assetDirName);
            var assetMatcher = profile.object.getAssetUpdateMatcher();
            makeUpdateRequest(assetDirName, assetDir, assetMatcher, digest, function(assetHDir) {
                settings.lastHDirs.put(assetDirName, assetHDir);

                // Update client dir
                update.resetOverlay("Обновление файлов клиента");
                var clientDirName = profile.object.block.getEntryValue("dir", StringConfigEntryClass) + (settings.shaders?config.shader:"");
                var clientDir = settings.updatesDir.resolve(clientDirName);
                var clientMatcher = profile.object.getClientUpdateMatcher();
                makeUpdateRequest(clientDirName, clientDir, clientMatcher, digest, function(clientHDir) {
                    settings.lastHDirs.put(clientDirName, clientHDir);
                    doLaunchClient(jvmDir, jvmHDir, assetDir, assetHDir, clientDir, clientHDir, profile, pp, accessToken);
                });
            });
        });
    });
}

function doLaunchClient(jvmDir, jvmHDir, assetDir, assetHDir, clientDir, clientHDir, profile, pp, accessToken) {
    processing.resetOverlay();
    overlay.swap(0, processing.overlay, function(event)
        launchClient(jvmDir, jvmHDir, assetHDir, clientHDir, profile, new ClientLauncherParams(settings.lastSign,
            assetDir, clientDir, pp, accessToken, false, settings.fullScreen, settings.ram, 0, 0), function(){ javafx.application.Platform.exit();})
    );
}
/* ======== Server handler functions ======== */
function updateProfilesList(profiles) {
    profilesList = [];
    // Set profiles items
    //profilesBox.setItems(javafx.collections.FXCollections.observableList(profiles));
    serverList.getChildren().clear();
    profiles.forEach(function (profile, i, arr) {
        pingers[profile.object] = new ServerPinger(profile.object.getServerSocketAddress(), profile.object.getVersion());
        var serverBtn = new javafx.scene.control.Button(profile);
        (function () {
			serverBtn.setStyle("-fx-background-image: url('/runtime/launcher/images/mainmenu/"+serverBtn.getText()+".png')"); 
			serverBtn.setText("");
            profilesList[serverBtn] = profile;
            var hold = serverBtn;
            serverBtn.setOnAction(function (event) {
				doUpdate(profile, loginData.pp, loginData.accessToken);
            });
        })();
        serverList.getChildren().add(serverBtn);
    });


}

function setServerStatus(description) {
    serverStatus.setText(description);
}

/* ======== Overlay helper functions ======== */
function fade(region, delay, from, to, onFinished) {
    var transition = new javafx.animation.FadeTransition(javafx.util.Duration.millis(100), region);
    if (onFinished !== null) {
        transition.setOnFinished(onFinished);
    }

    // Launch transition
    transition.setDelay(javafx.util.Duration.millis(delay));
    transition.setFromValue(from);
    transition.setToValue(to);
    transition.play();
}

var overlay = {
    current: null,

    show: function(newOverlay, onFinished) {
        // Freeze root pane
        authPane.setDisable(true);
        overlay.current = newOverlay;

        // Show dim pane
        dimPane.setVisible(true);
        dimPane.toFront();

        // Fade dim pane
        fade(dimPane, 0.0, 0.0, 1.0, function(event) {
            dimPane.requestFocus();
            dimPane.getChildren().add(newOverlay);

            // Fix overlay position
            newOverlay.setLayoutX((dimPane.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
            newOverlay.setLayoutY((dimPane.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);

            // Fade in
            fade(newOverlay, 0.0, 0.0, 1.0, onFinished);
        });
    },

    hide: function(delay, onFinished) {
        fade(overlay.current, delay, 1.0, 0.0, function(event) {
            dimPane.getChildren().remove(overlay.current);
            fade(dimPane, 0.0, 1.0, 0.0, function(event) {
                dimPane.setVisible(false);

                // Unfreeze root pane
                authPane.setDisable(false);
                rootPane.requestFocus();

                // Reset overlay state
                overlay.current = null;
                if (onFinished !== null) {
                    onFinished();
                }
            });
        });
    },

    swap: function(delay, newOverlay, onFinished) {
        dimPane.toFront();
        fade(overlay.current, delay, 1.0, 0.0, function(event) {
            dimPane.requestFocus();


            if(overlay.current==null){
                overlay.show(newOverlay, onFinished);
                return;
            }
            // Hide old overlay
            if (overlay.current !== newOverlay) {
                var child = dimPane.getChildren();
                child.set(child.indexOf(overlay.current), newOverlay);
            }

            // Fix overlay position
            newOverlay.setLayoutX((dimPane.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
            newOverlay.setLayoutY((dimPane.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);

            // Show new overlay
            overlay.current = newOverlay;
            fade(newOverlay, 0.0, 0.0, 1.0, onFinished);
        });
    }
};

var menuHolder = {
    old: null,

    set: function(btn){
        btn.setSelected(true);
        btn.setDisable(true);
        if(btn==serverPane.lookup("#newsbtn")) {
            serverPane.lookup("#newsPane").setDisable(false);
            serverPane.lookup("#newsPane").setVisible(true);
        }
        if(menuHolder.old==serverPane.lookup("#newsbtn")){
            serverPane.lookup("#newsPane").setDisable(true);
            serverPane.lookup("#newsPane").setVisible(false);
        }

        if(menuHolder.old!=null){
            menuHolder.old.setSelected(false);
            menuHolder.old.setDisable(false);
        }
        menuHolder.old = btn;
    }
};

/* ======== Overlay scripts ======== */
launcher.loadScript(Launcher.getResourceURL("launcher/overlay/processing/processing.js"));
launcher.loadScript(Launcher.getResourceURL("launcher/overlay/settings/settings.js"));
launcher.loadScript(Launcher.getResourceURL("launcher/overlay/update/update.js"));
