var processing = {
    overlay: null, spinner: null, description: null,tittle:null,
    processingImage: null, errorImage: null,

    initOverlay: function() {
        processing.overlay = loadFXML("launcher/overlay/processing/processing.fxml");

       
        processing.description = processing.overlay.lookup("#description");
        
        processing.tittle = processing.overlay.lookup("#label-text");

        processing.tittle.setText(langData.getProperty("runtime.scenes.processing.tittle"));
	
        processing.errorImage = new javafx.scene.image.Image(
            Launcher.getResourceURL("launcher/overlay/processing/error.png").toString());
    },

    resetOverlay: function() {
        processing.description.getStyleClass().remove("error");
        processing.description.setText("...");
    },

    setError: function(e) {
        LogHelper.error(e);
        processing.description.textProperty().unbind();
        processing.description.getStyleClass().add("error");
		if(e.toString().equals("Incorrect username or password")){
			processing.description.setText(langData.getProperty("runtime.scenes.processing.incorrect_username_password-ram"));
		}else if(e.toString().contains("Connection refused: connect")){
			processing.description.setText(langData.getProperty("runtime.scenes.processing.admin_problem"));
		}else if(e.toString().contains("оффлайн")){
			processing.description.setText(langData.getProperty("runtime.scenes.processing.admin_problem"));
		}else{
			processing.description.setText(e.toString());
		}
    },

    setTaskProperties: function(task, callback, errorCallback, hide) {
        processing.description.textProperty().bind(task.messageProperty());
        task.setOnFailed(function(event) {
            processing.description.textProperty().unbind();
            processing.setError(task.getException());
            if (hide) {
                overlay.hide(2500, errorCallback);
            } else if (errorCallback !== null) {
                errorCallback();
            }
        });
        task.setOnSucceeded(function(event) {
            processing.description.textProperty().unbind();
            if (callback !== null) {
                callback(task.getValue());
            }
        });
    }
};
function loadLocalizedStrings() {
    var lang = java.lang.System.getProperty("user.language");
    print("System Language: " + lang); // Выводим язык системы для отладки

    // Определяем путь к файлу свойств в зависимости от языка
    var resourcePath = "/runtime/runtime_" + lang + ".properties";

    // Проверяем, существует ли файл для выбранного языка
    var inputStream = Launcher.class.getResourceAsStream(resourcePath);
    if (inputStream == null) {
        print("Language file not found for: " + lang + ". Falling back to default (en).");
        // Если файл не найден, устанавливаем язык по умолчанию
        lang = "en";
        resourcePath = "/runtime/runtime_" + lang + ".properties";
        inputStream = Launcher.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new java.io.FileNotFoundException("Default language file not found: " + resourcePath);
        }
    }

    // Загружаем языковые данные с учетом UTF-8 кодировки
    langData = loadLanguageResourceFile(inputStream);
}

function loadLanguageResourceFile(inputStream) {
    var properties = new java.util.Properties();
    properties.load(new java.io.InputStreamReader(inputStream, java.nio.charset.StandardCharsets.UTF_8));
    inputStream.close();
    return properties;
}

loadLocalizedStrings();
function offlineLauncherRequest() {
    if (settings.lastSign === null || !settings.lastProfiles.isEmpty()) {
        Request.requestError(langData.getProperty("runtime.scenes.processing.offline_no"));
        return;
    }

    // Verify launcher signature
    SecurityHelper.verifySign(LauncherRequest.BINARY_PATH,
        settings.lastSign, Launcher.getConfig().publicKey);

    // Return last sign and profiles
    return {
        sign: settings.lastSign,
        profiles: settings.lastProfiles
    };
}

function offlineAuthRequest(login) {
    return function() {
        if (!VerifyHelper.isValidUsername(login)) {
            Request.requestError(langData.getProperty("runtime.scenes.processing.incorrect_username"));
            return;
        }

        // Return offline profile and random access token
        return {
            pp: PlayerProfile.newOfflineProfile(login),
            accessToken: SecurityHelper.randomStringToken()
        }
    };
}

/* Export functions */
function makeLauncherRequest(callback) {
    var task = settings.offline ? newTask(offlineLauncherRequest) :
        newRequestTask(new LauncherRequest());

    // Set task properties and start
    processing.setTaskProperties(task, callback, function() {
        if (settings.offline) {
            return;
        }

        // Repeat request, but in offline mode
        settings.offline = true;
        overlay.swap(2500, processing.overlay, function() makeLauncherRequest(callback));
    }, false);
    task.updateMessage(langData.getProperty("runtime.scenes.processing.server_list"));
    startTask(task);
}

function makeAuthRequest(login, rsaPassword, callback) {
    var task = rsaPassword === null ? newTask(offlineAuthRequest(login)) :
        newRequestTask(new AuthRequest(login, rsaPassword));
    processing.setTaskProperties(task, callback, null, true);
    task.updateMessage(langData.getProperty("runtime.scenes.processing.auth_for_server"));
    startTask(task);
}

function launchClient(jvmDir, jvmHDir, assetHDir, clientHDir, profile, params, callback) {
    var task = newTask(function() ClientLauncher.launch(jvmDir, jvmHDir, assetHDir, clientHDir,
        profile, params, LogHelper.isDebugEnabled()));
    processing.setTaskProperties(task, callback, null, true);
    task.updateMessage(langData.getProperty("runtime.scenes.processing.launchClient"));
    startTask(task);
}
