var update = {
    overlay: null, title: null, progress: null, volume: null, speed: null, currentTask: null, file: null, crystal: null,

    /* State and overlay functions */
    initOverlay: function() {
        update.overlay = loadFXML("launcher/overlay/update/update.fxml");

        // Lookup nodes
        update.speed = update.overlay.lookup("#speed");
        update.file = update.overlay.lookup("#file");
        update.crystal = update.overlay.lookup("#Crystal");


        update.overlay.lookup("#exitbtn").setOnAction(function(event) {
            javafx.application.Platform.exit();
        });
        update.progress = update.overlay.lookup("#progress");
        update.volume = update.overlay.lookup("#volume");
        update.cancelButton = update.overlay.lookup("#cancel");
        update.cancelButton.setOnAction(function() {
            cancelUpdate();
        });
    },

    resetOverlay: function(title) {
        update.progress.progressProperty().unbind();
        update.progress.setProgress(0.0);
        update.volume.setText("");
    },

    setError: function(e) {
        LogHelper.error(e);
    },

    stateCallback: function(task, state) {
        var bps = state.getBps();
        var estimated = state.getEstimatedTime();
        var estimatedSeconds = estimated === null ? 0 : estimated.getSeconds();
        // Update progress and message
        task.updateProgress(state.totalDownloaded, state.totalSize);
        task.updateMessage(java.lang.String.format(
            "%.1f Mbps%n",
            bps <= 0.0 ? 0.0 : bps / 102400.0 // Downloaded & Speed
        ));
        
        var progressPercent = (state.totalDownloaded / state.totalSize) * 100;

        // Update fill based on progress
        javafx.application.Platform.runLater(function() {
            var formattedProgress = Math.floor(progressPercent) + "%";
            update.volume.setText(formattedProgress);
            update.file.setText(state.filePath.length > 40 ? state.filePath.substring(0, 40) + "..." : state.filePath);

            // Update gradient fill based on progress
            var color1 = "#8152FF"; // Starting color
            var color2 = "#8CB9FF"; // Ending color
            var gradient = "linear-gradient(from 0% 0% to " + progressPercent + "%" + progressPercent+"%," + color1 + "," + color2 + ")";
            update.crystal.setStyle("-fx-fill: " + gradient);
        });
    },

    setTaskProperties: function(task, request, callback) {
        update.progress.progressProperty().bind(task.progressProperty());
        update.speed.textProperty().bind(task.messageProperty());
        // Проверяем, что update.progress.pro определено и не является undefined
        var volumeText = update.progress.pro ? update.progress.pro : "";
        update.volume.setText(volumeText);
        request.setStateCallback(function(state) update.stateCallback(task, state));
        task.setOnFailed(function(event) {
            update.speed.textProperty().unbind();
            update.progress.progressProperty().unbind();
            update.volume.setText("ERROR");
            update.setError(task.getException());
            overlay.hide(2500, null);
        });
        task.setOnSucceeded(function(event) {
            update.speed.textProperty().unbind();
            update.progress.progressProperty().unbind();
            update.volume.setText(""); // Очистка текста в поле volume
            if (callback !== null) {
                callback(task.getValue());
            }
        });
    }
    
};

function cancelUpdate() {
    if (update.currentTask !== null) {
        // Отмена текущей задачи
        update.currentTask.cancel();
        // Обнуление текущей задачи
        update.currentTask = null;
        // Закрываем overlay
        overlay.hide(0, null);
    }
}

function offlineUpdateRequest(dirName, dir, matcher, digest) {
    return function() {
        var hdir = settings.lastHDirs.get(dirName); 
        if (hdir === null) {
            Request.requestError(java.lang.String.format("Директории '%s' нет в кэше", dirName));
            return;
        }

        // Verify dir with matcher using ClientLauncher's API
        ClientLauncher.verifyHDir(dir, hdir.object, matcher, digest);
        return hdir;
    };
}

/* Export functions */
function makeUpdateRequest(dirName, dir, matcher, digest, callback) {
    var request = settings.offline ? { setStateCallback: function(stateCallback) { /* Ignored */ } } :
        // new UpdateRequest(dirName, dir, matcher, digest);
        ClientNodeManager.create(dirName, dir, matcher, digest);
    var task = settings.offline ? newTask(offlineUpdateRequest(dirName, dir, matcher, digest)) :
        newRequestTask(request);
        update.currentTask = task;
    // Set task properties and start
    update.setTaskProperties(task, request, callback);
    task.updateMessage(langData.getProperty("runtime.scenes.update.hashing"));
    task.updateProgress(-1, -1);
    startTask(task);
}
